<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Config;

class DBConnection
{
    /**Handle an incoming request.*
@param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next*/
public function handle(Request $request, Closure $next): Response{$organization = $request->segment(1);

        if (!$organization) {
            abort(403, 'Company name id required');
        }

        if ($organization) {
            $organization = DB::connection('mysql')->table('companies')->where('slug', $organization)->first();
        }

        if (!$organization) {
            abort(403, 'Company not found');
        }

        $temp_connection = config('database.connections.temp');
        $temp_connection['database'] = $organization->db_name;

        Config::set('database.connections.temp', $temp_connection);
        config(['database.default' => 'temp']);

        return $next($request);
    }
}