@extends('layouts.client')
@push('title', get_phrase('Dashboard'))
@push('meta')@endpush
@push('css')
@endpush
@section('content')
<style>
    /* Gradient Button */
    .btn-gradient {
        background: linear-gradient(135deg, #4f46e5, #9333ea);
        color: #fff;
        border: none;
        transition: all 0.3s ease;
    }
    .btn-gradient:hover {
        opacity: 0.9;
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(0,0,0,0.15);
        color: #fff;
    }
    /* Card Hover Effect */
    .package-card {
        transition: transform 0.35s ease, box-shadow 0.35s ease;
    }
    .package-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 12px 30px rgba(0,0,0,0.15);
    }
    /* Feature icon size tweak */
    .package-card i {
        font-size: 1.2rem;
    }
    span.billing_cycle {
        font-size: 14px;
        font-style: oblique;
    }
    .price_section {
        font-size: 10px !important;
        top: -9px;
        position: absolute;
        right: -4px;
    }
</style>
<div class="ol-card radius-8px">
    <div class="ol-card-body my-3 py-12px px-20px">
        <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
            <h4 class="title fs-16px">
                <i class="fi-rr-settings-sliders me-2"></i>
                {{ get_phrase('All Packages') }} <span class="text-muted">({{ $packages->count() }})</span>
            </h4>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="ol-card border-0 shadow-sm rounded-3 mb-5">
            <div class="ol-card-body p-4">
                <h2 class="fw-bold text-center mb-5">{{ get_phrase('Find the Perfect Package for You') }}</h2>
                <div class="row g-4">
                    @foreach ($packages as $package)
                        <div class="col-lg-4 col-md-6 mb-5">
                             @if(isset($purchasedPackageIds->id))
                                <!-- If NOT purchased → keep it clickable -->
                                <a>
                             @else
                                <!-- If already purchased → remove link wrapper -->
                                 <a href="{{ route('client.package.purchase', $package->id) }}">
                                
                             @endif
                                    <div class="card h-100 border-0 rounded-4 shadow-lg package-card overflow-hidden position-relative">
                                        <!-- Card Header with Gradient -->
                                        <div class="p-4 text-white text-center package-header" 
                                            style="background: linear-gradient(135deg, #4f46e5, #9333ea);">
                                            <h4 class="fw-bold mb-2">{{ ucfirst($package->title) }}</h4>
                                            <p class="small mb-0">{{ Str::limit($package->description, 60) }}</p>
                                        </div>

                                        <!-- Price Section (Glassmorphism) -->
                                        <div class="price_section m-3 bg-white bg-opacity-25 text-white px-3 py-1 rounded-pill shadow-sm"
                                            style="backdrop-filter: blur(8px);">
                                            {{ ($package->interval_preiod) }} <span>
                                                @if($package->interval === 'monthly')
                                                    {{ get_phrase('Month') }}
                                                @elseif($package->interval === 'yearly')
                                                    {{ get_phrase('Year') }}
                                                @elseif($package->interval === 'weekly')
                                                    {{ get_phrase('Week') }}
                                                @else
                                                    {{ get_phrase('Duration') }}
                                                @endif
                                            </span>

                                        </div>

                                        <!-- Card Body -->
                                        <div class="card-body d-flex flex-column p-4">
                                            <h5 class="text-center fw-bold mb-4">
                                                {{ currency($package->price, 2) }} / <span class="billing_cycle">{{ ucfirst($package->interval) }}</span>
                                            </h5>

                                            <!-- Features List -->
                                            <ul class="list-unstyled flex-grow-1">
                                                @php
                                                    $features = $package->features ? json_decode($package->features, true) : [];
                                                @endphp

                                                @if(count($features))
                                                    @foreach ($features as $feature)
                                                        <li class="mb-3 d-flex align-items-center">
                                                            <i style="font-size: 12px;" class="fas fa-check-circle text-success me-2"></i>
                                                            <span>{{ $feature }}</span>
                                                        </li>
                                                    @endforeach
                                                @endif
                                            </ul>

                                            <!-- Buy Button -->
                                            <div class="text-center mt-auto">
                                                @if(isset($purchasedPackageIds->id))
                                                <a href="#"
                                                class="btn btn-gradient rounded-pill px-4 py-2 fw-semibold shadow-sm" disabled style="font-size: 14px;">
                                                {{ get_phrase('Allready active a package') }}
                                                </a>
                                                @else
                                                <a href="{{ route('client.package.purchase', $package->id) }}"
                                                class="btn btn-gradient rounded-pill px-4 py-2 fw-semibold shadow-sm" style="font-size: 14px;">
                                                {{ get_phrase('Buy Now') }}
                                                </a>
                                                @endif
                                            </div>

                                        </div>
                                    </div>            
                                </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

@endsection