<?php

namespace App\Http\Controllers\Superadmin;


use App\Models\Message;
use App\Models\MessageThread;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use App\Models\FileUploader;
use App\Models\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SuperadminController extends Controller
{
    public function dashboard()
    {
        return view('superadmin.dashboard.index');
    }

    
    public function client_index(Request $request)
    {
        $query = User::where('role', 'client');

        if ($request->has('search') && $request->search != '') {
            $search = $request->search;
            $query->where(function ($q) use ($search) {
                $q->where('name', 'LIKE', '%' . $search . '%')
                ->orWhere('email', 'LIKE', '%' . $search . '%');
            });
        }

        $page_data['clients'] = $query->paginate(10);

        if ($request->has('search')) {
            $page_data['clients']->appends(['search' => $request->search]);
        }

        return view('superadmin.client.index', $page_data);
    }


    public function client_create()
    {
        return view('superadmin.client.create_client');
    }

    public function client_edit($id = '')
    {
        $page_data['client'] = User::where('id', $id)->first();
        return view('superadmin.client.edit_client', $page_data);
    }

    public function client_store(Request $request, $id = '')
    {
        $validated = $request->validate([
            'name'     => 'required|max:255',
            'email'    => 'required|email|unique:users',
            'password' => 'required',
        ]);

        $data['name']        = $request->name;
        $data['about']       = $request->about;
        $data['phone']       = $request->phone;
        $data['address']     = $request->address;
        $data['email']       = $request->email;
        $data['facebook']    = $request->facebook;
        $data['twitter']     = $request->twitter;
        $data['website']     = $request->website;
        $data['linkedin']    = $request->linkedin;
        $data['paymentkeys'] = json_encode($request->paymentkeys);
        $data['status']     = '1';

        $data['password'] = Hash::make($request->password);
        $data['role']     = 'client';


        if (isset($request->photo) && $request->hasFile('photo')) {
            $path = "uploads/users/client/" . nice_file_name($request->name, $request->photo->extension());
            FileUploader::upload($request->photo, $path, 400, null, 200, 200);
            $data['photo'] = $path;
        }

        if($request->email_verified == 1){
            $data['email_verified_at'] = date('Y-m-d H:i:s');
        }
        $client = User::create($data);

        if($request->email_verified != 1){
            $client->sendEmailVerificationNotification();
        }


        Session::flash('success', get_phrase('Client add successfully'));

        return redirect()->route('superadmin.client.index');
    }

    public function client_update(Request $request, $id = '')
    {
        $validated = $request->validate([
            'name'  => 'required|max:255',
            'email' => "required|email|unique:users,email,$id",
        ]);

        $data['name']        = $request->name;
        $data['about']       = $request->about;
        $data['phone']       = $request->phone;
        $data['address']     = $request->address;
        $data['email']       = $request->email;
        $data['facebook']    = $request->facebook;
        $data['twitter']     = $request->twitter;
        $data['website']     = $request->website;
        $data['linkedin']    = $request->linkedin;
        $data['paymentkeys'] = json_encode($request->paymentkeys);

        if (isset($request->photo) && $request->hasFile('photo')) {
            remove_file(User::where('id', $id)->first()->photo);
            $path = "uploads/users/client/" . nice_file_name($request->name, $request->photo->extension());
            FileUploader::upload($request->photo, $path, 400, null, 200, 200);
            $data['photo'] = $path;
        }

        User::where('id', $id)->update($data);
        Session::flash('success', get_phrase('Client update successfully'));
        return redirect()->route('superadmin.client.index');
    }

    public function client_delete($id)
    {
        $threads = MessageThread::where('contact_one', $id)
                    ->orWhere('contact_two', $id)
                    ->pluck('id');

        if ($threads->isNotEmpty()) {
            Message::whereIn('thread_id', $threads)->delete();
            MessageThread::whereIn('id', $threads)->delete();
        }

        $query = User::where('id', $id);
        remove_file($query->first()->photo);
        $query->delete();
        return redirect(route('superadmin.client.index'))->with('success', get_phrase('Client deleted successfully'));
    }

    public function domain_history($id)
    {
        $companies = DB::table('companies')->where('user_id', $id)->get();
        
        return view('superadmin.client.domain_history', compact('companies'));
    }
}
