<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'user_id',
        'name',
        'company_url',
        'slug',
        'db_name',
        'status',
        'package_id',
        'purchase_date',
        'expire_date',
    ];

    public function payments()
    {
        return $this->hasMany(Payment_history::class, 'package_id', 'id');
    }
}
