          <div class="table-responsive">
              <table class="table table-bordered table-striped align-middle">
                  <thead class="table-dark text-center">
                      <tr>
                          <th>#</th>
                          <th>{{ get_phrase('Domain URL') }}</th>
                          <th>{{ get_phrase('Status') }}</th>
                          <th>{{ get_phrase('Expired Date') }}</th>
                          <th>{{ get_phrase('Created Date') }}</th>
                      </tr>
                  </thead>
                  <tbody>
                      @forelse($companies as $key => $company)
                          <tr>
                              <td class="text-center">{{ $key + 1 }}</td>
                              <td>
                                  <a href="{{ $company->company_url }}" target="_blank" class="text-decoration-underline text-primary">
                                      {{ $company->company_url }}
                                  </a>
                              </td>
                              <td class="text-center">
                                  @if($company->status == 'active')
                                      <span class="badge bg-success">{{ ucfirst($company->status) }}</span>
                                  @elseif($company->status == 'expired')
                                      <span class="badge bg-danger">{{ ucfirst($company->status) }}</span>
                                  @elseif($company->status == 'canceled')
                                      <span class="badge bg-danger">{{ ucfirst($company->status) }}</span>
                                  @else
                                      <span class="badge bg-secondary">{{ ucfirst($company->status) }}</span>
                                  @endif
                              </td>
                              <td class="text-center">{{ \Carbon\Carbon::parse($company->expire_date)->format('d M, Y') }}</td>
                              <td class="text-center">{{ \Carbon\Carbon::parse($company->purchase_date)->format('d M, Y') }}</td>
                          </tr>
                      @empty
                          <tr>
                              <td colspan="5" class="text-center text-muted">
                                  {{ get_phrase('No domain history found') }}
                              </td>
                          </tr>
                      @endforelse
                  </tbody>
              </table>