<form action="{{ route('superadmin.package.update', ['id' => $package->id]) }}" method="post">
        @csrf

        {{-- Package Name --}}
        <div class="mb-3">
            <label for="package_name" class="form-label ol-form-label">{{ get_phrase('Package Name') }}</label>
            <input type="text" name="title" class="form-control ol-form-control" id="package_name" 
                value="{{ old('title', $package->title) }}"
                placeholder="{{ get_phrase('Enter your package name') }}" required />
        </div>

        {{-- Description --}}
        <div class="mb-3">
            <label for="description" class="form-label ol-form-label">{{ get_phrase('Package Description') }} 
                <small class="text-muted">({{ get_phrase('optional') }})</small>
            </label>
            <textarea name="description" rows="4" class="form-control ol-form-control" 
                id="description" placeholder="{{ get_phrase('Enter your description') }}">{{ old('description', $package->description) }}</textarea>
        </div>

        {{-- Price --}}
        <div class="mb-3">
            <label for="price" class="form-label ol-form-label">{{ get_phrase('Price') }}</label>
            <input type="number" name="price" step="0.01" class="form-control ol-form-control" id="price" 
                value="{{ old('price', $package->price) }}"
                placeholder="{{ get_phrase('Enter price') }}" required />
        </div>

        <div class="mb-3">
                <label for="interval" class="form-label ol-form-label">{{ get_phrase('Interval') }}</label>
                <select name="interval" id="interval" class="form-select ol-form-control" required>
                    <option value="monthly" {{ old('interval', $package->interval) =='monthly' ? 'selected' : '' }}>
                        {{ get_phrase('Monthly') }}
                    </option>
                    <option value="yearly" {{ old('interval', $package->interval) == 'yearly' ? 'selected' : '' }}> 
                        {{ get_phrase('Yearly') }}
                    </option>
                    <option value="day" {{ old('interval', $package->interval) == 'day' ? 'selected' : '' }}>
                        {{ get_phrase('day') }}
                    </option>
                </select>
            </div>

            {{-- Duration (optional if you want custom days) --}}
            <div class="mb-3">
                <label for="interval_preiod" class="form-label ol-form-label">{{ get_phrase('Duration ') }} 
                </label>
                <input type="number" name="interval_preiod" class="form-control ol-form-control" id="interval_preiod" value="{{ old('interval_preiod', $package->interval_preiod) }}"
                    placeholder="{{ get_phrase('Enter package duration') }}" 
                    aria-label="{{ get_phrase('Enter package duration') }}" />
            </div>

        {{-- Features --}}
        @php
            $features = $package->features ? implode(', ', json_decode($package->features, true)) : '';
        @endphp
        <div class="mb-3">
            <label for="features" class="form-label ol-form-label">{{ get_phrase('Features') }}</label>
            <textarea name="features" rows="3" class="form-control ol-form-control" id="features"
                placeholder="{{ get_phrase('Enter features separated by commas') }}">{{ old('features', $features) }}</textarea>
        </div>

        {{-- Status --}}
        <div class="mb-3">
            <label for="status" class="form-label ol-form-label">{{ get_phrase('Status') }}</label>
            <select name="status" id="status" class="form-select ol-form-control" required>
                <option value="1" {{ old('status', $package->status) == 1 ? 'selected' : '' }}>
                    {{ get_phrase('Active') }}
                </option>
                <option value="0" {{ old('status', $package->status) == 0 ? 'selected' : '' }}>
                    {{ get_phrase('Inactive') }}
                </option>
            </select>
        </div>

        {{-- Submit --}}
        <div class="mb-2">
            <button class="btn ol-btn-primary">{{ get_phrase('Update') }}</button>
        </div>
</form>