<?php
use App\Http\Controllers\Superadmin\SuperadminController;
use App\Http\Controllers\Superadmin\PackageController;
use App\Http\Controllers\UsersController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ModalController;


Route::name('superadmin.')->prefix('superadmin')->middleware('superadmin')->group(function () {
    //dashboard
    Route::get('dashboard', [SuperadminController::class, 'dashboard'])->name('dashboard');
    Route::get('phpinfo', function(){
        phpinfo();
    });

    //Package
    Route::get('packages', [PackageController::class, 'index'])->name('package.index');
    Route::get('package/create', [PackageController::class, 'create'])->name('package.create');
    Route::post('package/store', [PackageController::class, 'store'])->name('package.store');
    Route::get('package/edit/{id}', [PackageController::class, 'edit'])->name('package.edit');
    Route::post('package/update/{id}', [PackageController::class, 'update'])->name('package.update');
    Route::get('package/delete/{id}', [PackageController::class, 'delete'])->name('package.delete');

    // Package Payment History
    Route::get('payment-history', [PackageController::class, 'payment_history_index'])->name('payment_history.index');

    Route::controller(SuperadminController::class)->group(function () {
        //Client Create
        Route::get('clients', 'client_index')->name('client.index');
        Route::get('client/create', 'client_create')->name('client.create');
        Route::post('client/store/{id?}', 'client_store')->name('client.store');
        Route::get('client/edit/{id}', 'client_edit')->name('client.edit');
        Route::post('client/update/{id}', 'client_update')->name('client.update');
        Route::get('client/delete/{id}', 'client_delete')->name('client.delete');

        Route::get('clients/domain-history/{id}', 'domain_history')->name('client.domain_history');


    });


});

Route::get('modal/{view_path}', [ModalController::class, 'common_view_function'])->name('modal');