<?php $__env->startPush('title', get_phrase('Player settings')); ?>

<style>
    .preview-watermark {
        width: 100%;
        aspect-ratio: 1/1;
        overflow: hidden;
    }

    .preview-watermark img {
        width: 100%;
    }
</style>

<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-4 px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Player settings')); ?>

                </h4>
            </div>
        </div>
    </div>


    <form action="<?php echo e(route('admin.player.settings.update')); ?>" method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <input type="hidden" name="type" value="watermark">

        <div class="row">
            <div class="col-md-7 col-xl-8 col-xxl-7">
                <div class="ol-card p-4">
                    <div class="ol-card-body">
                        <div class="mb-3">
                            <label class="form-label ol-form-label"><?php echo e(get_phrase('Watermark Type')); ?></label>
                            <select class="form-control ol-select2" data-toggle="select2" name="watermark_type" required>
                                <option value=""><?php echo e(get_phrase('Select an option')); ?></option>
                                <option value="disabled" <?php if(get_player_settings('watermark_type') == 'disabled'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Disabled')); ?></option>
                                <option value="js" <?php if(get_player_settings('watermark_type') == 'js'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Js Watermark')); ?></option>
                                <option value="ffmpeg" <?php if(get_player_settings('watermark_type') == 'ffmpeg'): ?> selected <?php endif; ?>>
                                    <?php echo e(get_phrase('FFMpeg')); ?></option>
                            </select>
                        </div>

                        <div class="mb-3 mt-2">
                            <img height="60px" src="<?php echo e(get_image(get_player_settings('watermark_logo') ?? 'no-image')); ?>" alt="">


                            <label class="form-label ol-form-label" for="width"><?php echo e(get_phrase('Watermark')); ?></label>
                            <input type="file" class="form-control ol-form-control" id="watermark" name="watermark_logo" onchange="loadImage(this, '.preview-watermark img')">
                        </div>

                        <div class="mb-3">
                            <label class="form-label ol-form-label" for="animation_speed"><?php echo e(get_phrase('Animation speed')); ?></label>
                            <input type="number" for="animation_speed" class="form-control ol-form-control" name="animation_speed" value="<?php echo e(get_player_settings('animation_speed')); ?>" placeholder="<?php echo e(get_phrase('Second (0 - 10000)')); ?>" min="0" max="10000">
                        </div>

                        <div class="mb-3">
                            <label class="form-label ol-form-label" for="opacity"><?php echo e(get_phrase('Opacity')); ?></label>
                            <input type="number" for="opacity" class="form-control ol-form-control" name="watermark_opacity" value="<?php echo e(get_player_settings('watermark_opacity')); ?>" placeholder="<?php echo e(get_phrase('Opacity (0 - 100)')); ?>" min="0" max="100">
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label ol-form-label" for="width"><?php echo e(get_phrase('Width')); ?></label>
                                    <input type="number" for="width" class="form-control ol-form-control" name="watermark_width" value="<?php echo e(get_player_settings('watermark_width')); ?>" placeholder="<?php echo e(get_phrase('Width (px)')); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label ol-form-label" for="height"><?php echo e(get_phrase('Height')); ?></label>
                                    <input type="number" for="height" class="form-control ol-form-control" name="watermark_height" value="<?php echo e(get_player_settings('watermark_height')); ?>" placeholder="<?php echo e(get_phrase('Height (px)')); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label ol-form-label" for="top"><?php echo e(get_phrase('Top')); ?></label>
                                    <input type="number" for="top" class="form-control ol-form-control" name="watermark_top" value="<?php echo e(get_player_settings('watermark_top')); ?>" placeholder="<?php echo e(get_phrase('Top (px)')); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label ol-form-label" for="left"><?php echo e(get_phrase('left')); ?></label>
                                    <input type="number" for="left" class="form-control ol-form-control" name="watermark_left" value="<?php echo e(get_player_settings('watermark_left')); ?>" placeholder="<?php echo e(get_phrase('Left (px)')); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Save changes')); ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\academyLMS_sass\Academy-LMS\resources\views/admin/setting/player_settings.blade.php ENDPATH**/ ?>