<?php $__env->startPush('title', get_phrase('System settings')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Mani section header and breadcrumb -->
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-4 px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('System Settings')); ?>

                </h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-7">
            <div class="ol-card p-4">
                <h3 class="title text-14px mb-3"><?php echo e(get_phrase('System Settings')); ?></h3>
                <div class="ol-card-body">
                    <div class="col-lg-12">

                        <form class="required-form" action="<?php echo e(route('admin.system.settings.update')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="system_name"><?php echo e(get_phrase('Website name')); ?><span>*</span></label>
                                <input type="text" name = "system_name" id = "system_name" class="form-control ol-form-control" value="<?php echo e(get_settings('system_name')); ?>" required>
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="system_title"><?php echo e(get_phrase('Website title')); ?><span>*</span></label>
                                <input type="text" name = "system_title" id = "system_title" class="form-control ol-form-control" value="<?php echo e(get_settings('system_title')); ?>" required>
                            </div>

                            <div class="fpb-7 mb-3">
                                <label for="website_keywords" class="form-label ol-form-label"><?php echo e(get_phrase('Website keywords')); ?></label>
                                <input type="text" class="form-control ol-form-control bootstrap-tag-input w-100" id = "website_keywords" name="website_keywords" data-role="tagsinput" value="<?php echo e(get_settings('website_keywords')); ?>" />
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="website_description"><?php echo e(get_phrase('Website description')); ?></label>
                                <textarea name="website_description" id = "website_description" class="form-control ol-form-control" rows="5"><?php echo e(get_settings('website_description')); ?></textarea>
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="author"><?php echo e(get_phrase('Author')); ?></label>
                                <input type="text" name = "author" id = "author" class="form-control ol-form-control" value="<?php echo e(get_settings('author')); ?>">
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="slogan"><?php echo e(get_phrase('Slogan')); ?><span>*</span></label>
                                <input type="text" name = "slogan" id = "slogan" class="form-control ol-form-control" value="<?php echo e(get_settings('slogan')); ?>" required>
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="system_email"><?php echo e(get_phrase('System email')); ?><span>*</span></label>
                                <input type="text" name = "system_email" id = "system_email" class="form-control ol-form-control" value="<?php echo e(get_settings('system_email')); ?>" required>
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="address"><?php echo e(get_phrase('Address')); ?></label>
                                <textarea name="address" id = "address" class="form-control ol-form-control" rows="5"><?php echo e(get_settings('address')); ?></textarea>
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="phone"><?php echo e(get_phrase('Phone')); ?></label>
                                <input type="text" name = "phone" id = "phone" class="form-control ol-form-control" value="<?php echo e(get_settings('phone')); ?>">
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="youtube_api_key"><?php echo e(get_phrase('Youtube API key')); ?><span>*</span> &nbsp; <a href = "https://developers.google.com/youtube/v3/getting-started" target = "_blank" class="text-12px text-secondary">(<?php echo e(get_phrase('Get YouTube API key')); ?> <i class="mdi mdi-open-in-new"></i>)</a></label>
                                <input type="text" name = "youtube_api_key" id = "youtube_api_key" class="form-control ol-form-control" value="<?php echo e(get_settings('youtube_api_key')); ?>" required>
                                <a href="https://support.google.com/googleapi/answer/6158841" target="_blank" class="text-12px text-secondary">
                                    <?php echo e(get_phrase('If you want to use Google Drive video, you need to enable the Google Drive service in this API')); ?>

                                </a>
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="vimeo_api_key"><?php echo e(get_phrase('Vimeo API key')); ?><span>*</span>
                                    &nbsp; <a href = "https://www.youtube.com/watch?v=Wwy9aibAd54" target = "_blank" class="text-12px text-secondary">(<?php echo e(get_phrase('get Vimeo API key')); ?> <i class="mdi mdi-open-in-new"></i>)</a></label>
                                <input type="text" name = "vimeo_api_key" id = "vimeo_api_key" class="form-control ol-form-control" value="<?php echo e(get_settings('vimeo_api_key')); ?>" required>
                            </div>

                            <div class="fpb-7 mb-3">
                                <label for="purchase_code"><?php echo e(get_phrase('Purchase code')); ?><span class="form-label ol-form-label">*</span></label>
                                <input type="text" name = "purchase_code" id = "purchase_code" class="form-control ol-form-control" value="<?php echo e(get_settings('purchase_code')); ?>" required>
                            </div>
                            
                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="language"><?php echo e(get_phrase('System language')); ?></label>
                                <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="language" id="language">
                                    <?php $__currentLoopData = App\Models\Language::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e(strtolower($language->name)); ?>" <?php if(get_settings('language') == strtolower($language->name)): ?> selected <?php endif; ?>><?php echo e($language->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>


                            <div class="fpb-7 mb-3 ">
                                <label class="form-label ol-form-label" for="course_selling_tax"><?php echo e(get_phrase('Course selling tax')); ?> (%)
                                    <span>*</span></label>
                                <div class="input-group">
                                    <input type="number" value="<?php echo e(get_settings('course_selling_tax')); ?>" min="0" max="100" id="course_selling_tax" name="course_selling_tax" class="form-control ol-form-control" required>
                                    <div class="input-group-append">
                                        <span class="input-group-text ol-form-control">%</span>
                                    </div>
                                </div>
                                <small><?php echo e(get_phrase('Enter 0 if you want to disable the tax option')); ?></small>
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="student_email_verification"><?php echo e(get_phrase('Student email verification')); ?></label>
                                <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="student_email_verification" id="student_email_verification">
                                    <option value="0" <?php if(get_settings('student_email_verification') != 1): ?> selected <?php endif; ?>><?php echo e(get_phrase('Disabled')); ?></option>
                                    <option value="1" <?php if(get_settings('student_email_verification') == 1): ?> selected <?php endif; ?>><?php echo e(get_phrase('Enabled')); ?></option>
                                </select>
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="device_limitation"><?php echo e(get_phrase('Device limitation')); ?></label>
                                <input type="number" name="device_limitation" id="device_limitation" class="form-control ol-form-control" value="<?php echo e(get_settings('device_limitation')); ?>" required>
                                <p style="font-size: 12px; font-weight: 500;"><?php echo e(get_phrase("Specify the maximum number of devices a user can log in from. If set to 0, users will be able to log in from an unlimited number of devices.")); ?></p>
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="timezone"><?php echo e(get_phrase('Timezone')); ?></label>
                                <select class="form-control ol-form-control ol-select2" data-toggle="select2" id="timezone" name="timezone" required>
                                    <?php $tzlist = DateTimeZone::listIdentifiers(DateTimeZone::ALL); ?>
                                    <?php $__currentLoopData = $tzlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tz): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($tz); ?>" <?php echo e(get_settings('timezone') == $tz ?  'selected':''); ?>><?php echo e($tz); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="footer_text"><?php echo e(get_phrase('Footer text')); ?></label>
                                <input type="text" name = "footer_text" id = "footer_text" class="form-control ol-form-control" value="<?php echo e(get_settings('footer_text')); ?>">
                            </div>

                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" for="footer_link"><?php echo e(get_phrase('Footer link')); ?></label>
                                <input type="text" name = "footer_link" id = "footer_link" class="form-control ol-form-control" value="<?php echo e(get_settings('footer_link')); ?>">
                            </div>

                            <button type="submit" class="btn ol-btn-primary" onclick="checkRequiredFields()"><?php echo e(get_phrase('Save Changes')); ?></button>
                        </form>


                    </div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
        <div class="col-xl-5">
            <div class="ol-card p-4">
                <h3 class="title text-14px mb-3"><?php echo e(get_phrase('Update Product')); ?></h3>
                <div class="ol-card-body">
                    <div class="col-lg-12">
                        <form action="<?php echo e(route('admin.product.update')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label" class=""><?php echo e(get_phrase('File')); ?></label>

                                <input type="file" class="form-control ol-form-control" id="file_name" name="file" required onchange="changeTitleOfImageUploader(this)">
                            </div>

                            <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Update')); ?></button>
                        </form>
                    </div>
                </div> <!-- end card body-->
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?><?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\academyLMS_sass\Academy-LMS\resources\views/admin/setting/system_setting.blade.php ENDPATH**/ ?>