<?php $__env->startPush('title', get_phrase('Sign Up')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        .form-icons .right {
            right: 20px;
            cursor: pointer !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <section class="login-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-7 col-md-6">
                    <div class="login-img">
                        <img src="<?php echo e(asset('assets/frontend/' . get_frontend_settings('theme') . '/image/signup.gif')); ?>" alt="register-banner">
                    </div>
                </div>
                <div class="col-lg-5 col-md-6">
                    <form action="<?php echo e(route('register')); ?>" class="global-form login-form mt-25" id="login-form" method="post" enctype="multipart/form-data"><?php echo csrf_field(); ?>
                        <h4 class="g-title"><?php echo e(get_phrase('Sign Up')); ?></h4>
                        <p class="description"><?php echo e(get_phrase('See your growth and get consulting support! ')); ?></p>
                        <div class="form-group mb-5">
                            <label for="" class="form-label"><?php echo e(get_phrase('Name')); ?></label>
                            <input type="text" name="name" class="form-control" placeholder="Your Name">

                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group mb-5">
                            <label for="" class="form-label"><?php echo e(get_phrase('Email')); ?></label>
                            <input type="email" name="email" class="form-control" placeholder="Your Email">

                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group mb-5">
                            <label for="" class="form-label"><?php echo e(get_phrase('Password')); ?></label>
                            <input type="password" name="password" class="form-control" placeholder="*********">

                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <?php if(get_settings('allow_instructor')): ?>
                            <div class="form-group mb-5">
                                <input id="instructor" type="checkbox" name="instructor">
                                <label for="instructor"><?php echo e(get_phrase('Apply to Become an instructor')); ?></label>
                            </div>

                            <div id="become-instructor-fields" class="d-none">
                                <div class="form-group mb-5">
                                    <label for="phone" class="form-label"><?php echo e(get_phrase('Phone')); ?></label>
                                    <input class="form-control" id="phone" type="phone" name="phone" placeholder="<?php echo e(get_phrase('Enter your phone number')); ?>">
                                </div>
                                <div class="form-group mb-5">
                                    <label for="document" class="form-label"><?php echo e(get_phrase('Document')); ?> <small>(doc, docs, pdf, txt, png, jpg, jpeg)</small></label>
                                    <input class="form-control" id="document" type="file" name="document">
                                    <small><?php echo e(get_phrase('Provide some documents about your qualifications')); ?></small>
                                </div>
                                <div class="form-group mb-5">
                                    <label for="description" class="form-label"><?php echo e(get_phrase('Message')); ?></label>
                                    <textarea class="form-control" id="description" name="description" rows="4"></textarea>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if(get_frontend_settings('recaptcha_status')): ?>
                            <button class="eBtn gradient w-100 g-recaptcha" data-sitekey="<?php echo e(get_frontend_settings('recaptcha_sitekey')); ?>" data-callback='onLoginSubmit' data-action='submit'><?php echo e(get_phrase('Sign Up')); ?></button>
                        <?php else: ?>
                            <button type="submit" class="eBtn gradient w-100"><?php echo e(get_phrase('Sign Up')); ?></button>
                        <?php endif; ?>

                        <p class="mt-20"><?php echo e(get_phrase('Already have account?')); ?> <a href="<?php echo e(route('login')); ?>"><?php echo e(get_phrase('Sign in')); ?></a></p>
                    </form>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        "use strict";

        $(document).ready(function() {
            $('#showpassword').on('click', function(e) {
                e.preventDefault();
                const type = $('#password').attr('type');

                if (type == 'password') {
                    $('#password').attr('type', 'text');
                } else {
                    $('#password').attr('type', 'password');
                }
            });
        });

        $(document).ready(function() {
            $('#showcpassword').on('click', function(e) {
                e.preventDefault();
                const type = $('#cpassword').attr('type');

                if (type == 'password') {
                    $('#cpassword').attr('type', 'text');
                } else {
                    $('#cpassword').attr('type', 'password');
                }
            });
        });

        function onLoginSubmit(token) {
            document.getElementById("login-form").submit();
        }

        $(document).ready(function() {
            $('#instructor').on('change', function () {
                if ($(this).is(':checked')) {
                    $('#become-instructor-fields').removeClass('d-none');
                    $('#phone').attr('required', true);
                    $('#document').attr('required', true);
                } else {
                    $('#become-instructor-fields').addClass('d-none');
                    $('#phone').removeAttr('required');
                    $('#document').removeAttr('required');
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.' . get_frontend_settings('theme'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\academy_lms_sass\academy\resources\views/auth/register.blade.php ENDPATH**/ ?>