<form action="<?php echo e(route('admin.package.store')); ?>" method="post" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>

    <div class="row">
        <div class="col-12">

            
            <div class="mb-3">
                <label for="package_name" class="form-label ol-form-label"><?php echo e(get_phrase('Package Name')); ?></label>
                <input type="text" name="title" class="form-control ol-form-control" id="package_name" 
                    placeholder="<?php echo e(get_phrase('Enter your package name')); ?>"
                    aria-label="<?php echo e(get_phrase('Enter your unique package name')); ?>" required />
            </div>

            
            <div class="mb-3">
                <label for="description" class="form-label ol-form-label"><?php echo e(get_phrase('Package Description')); ?> 
                    <small class="text-muted">(<?php echo e(get_phrase('optional')); ?>)</small>
                </label>
                <textarea name="description" rows="4" class="form-control ol-form-control" id="description" 
                    placeholder="<?php echo e(get_phrase('Enter your description')); ?>"
                    aria-label="<?php echo e(get_phrase('Enter your description')); ?>"></textarea>
            </div>

            <div class="mb-3">
                <label for="features" class="form-label ol-form-label"><?php echo e(get_phrase('Features')); ?></label>
                <textarea name="features" rows="3" class="form-control ol-form-control" id="features"
                    placeholder="<?php echo e(get_phrase('Enter features separated by commas')); ?>"></textarea>
            </div>


            
            <div class="mb-3">
                <label for="price" class="form-label ol-form-label"><?php echo e(get_phrase('Price')); ?></label>
                <input type="number" name="price" step="0.01" class="form-control ol-form-control" id="price" 
                    placeholder="<?php echo e(get_phrase('Enter price')); ?>"
                    aria-label="<?php echo e(get_phrase('Enter package price')); ?>" required />
            </div>

            
            <div class="mb-3">
                <label for="interval" class="form-label ol-form-label"><?php echo e(get_phrase('Interval')); ?></label>
                <select name="interval" id="interval" class="form-select ol-form-control" required>
                    <option value="monthly"><?php echo e(get_phrase('Monthly')); ?></option>
                    <option value="yearly"><?php echo e(get_phrase('Yearly')); ?></option>
                    <option value="day"><?php echo e(get_phrase('Day')); ?></option>
                </select>
            </div>

            <div class="mb-3">
                <label for="interval_preiod" class="form-label ol-form-label"><?php echo e(get_phrase('Duration ')); ?> 
                </label>
                <input type="number" name="interval_preiod" class="form-control ol-form-control" id="interval_preiod" 
                    placeholder="<?php echo e(get_phrase('Enter package duration')); ?>" 
                    aria-label="<?php echo e(get_phrase('Enter package duration')); ?>" />
            </div>

            
            <div class="mb-3">
                <label for="status" class="form-label ol-form-label"><?php echo e(get_phrase('Status')); ?></label>
                <select name="status" id="status" class="form-select ol-form-control" required>
                    <option value="1"><?php echo e(get_phrase('Active')); ?></option>
                    <option value="0"><?php echo e(get_phrase('Inactive')); ?></option>
                </select>
            </div>

            
            <div class="mb-2">
                <button class="btn ol-btn-primary"><?php echo e(get_phrase('Submit')); ?></button>
            </div>

        </div>
    </div>
</form>

<?php /**PATH C:\MAMP\htdocs\academyLMS_sass\Academy-LMS\resources\views/admin/package/create.blade.php ENDPATH**/ ?>