<?php $__env->startPush('title', get_phrase('Manage profile')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $auth = auth()->user();
    ?>

    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-4 px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <span><?php echo e(get_phrase('Manage profile')); ?></span>
                </h4>
            </div>
        </div>
    </div>

    <div class="row ">
        <div class="col-xl-7">
            <div class="ol-card p-4">
                <div class="ol-card-body">
                    <form action="<?php echo e(route('client.manage.profile.update')); ?>" method="post" enctype="multipart/form-data"><?php echo csrf_field(); ?>
                        <input type="hidden" name="type" value="general">
                        <div class="fpb7 mb-2">
                            <label class="form-label ol-form-label"><?php echo e(get_phrase('Name')); ?></label>
                            <input type="text" class="form-control ol-form-control" name="name" value="<?php echo e($auth->name); ?>" required />
                        </div>

                        <div class="fpb7 mb-2">
                            <label class="form-label ol-form-label"><?php echo e(get_phrase('Email')); ?></label>
                            <input type="email" class="form-control ol-form-control" name="email" value="<?php echo e($auth->email); ?>" required />
                        </div>

                        <div class="fpb7 mb-2">
                            <label class="form-label ol-form-label"><?php echo e(get_phrase('Facebook link')); ?></label>
                            <input type="text" class="form-control ol-form-control" name="facebook" value="<?php echo e($auth->facebook); ?>" />
                        </div>

                        <div class="fpb7 mb-2">
                            <label class="form-label ol-form-label"><?php echo e(get_phrase('Twitter link')); ?></label>
                            <input type="text" class="form-control ol-form-control" name="twitter" value="<?php echo e($auth->twitter); ?>" />
                        </div>

                        <div class="fpb7 mb-2">
                            <label class="form-label ol-form-label"><?php echo e(get_phrase('Linkedin link')); ?></label>
                            <input type="text" class="form-control ol-form-control" name="linkedin" value="<?php echo e($auth->linkedin); ?>" />
                        </div>

                        <div class="fpb7 mb-2">
                            <label class="form-label ol-form-label"><?php echo e(get_phrase('Biography')); ?></label>
                            <textarea rows="5" class="form-control ol-form-control text_editor" name="biography" placeholder=""><?php echo removeScripts($auth->biography); ?></textarea>
                        </div>


                        <div class="fpb7 mb-2">
                            <label class="form-label ol-form-label"><?php echo e(get_phrase('Photo')); ?>

                                <small>(<?php echo e(get_phrase('The image size should be any square image')); ?>)</small>
                            </label>
                            <div class="row align-items-center">
                                <div class="col-2">
                                    <img class = "rounded-circle img-thumbnail image-50" src="<?php echo e(get_image($auth->photo)); ?>" alt="">
                                </div>
                                <div class="col-10">
                                    <input type="file" class="form-control ol-form-control" name="photo" id="user_image" onchange="changeTitleOfImageUploader(this.id)" accept="image/*">
                                </div>
                            </div>
                        </div>

                        <div class="fpb7 mb-2">
                            <button type="submit" class="btn mt-4 ol-btn-primary"><?php echo e(get_phrase('Update profile')); ?></button>
                        </div>
                    </form>

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div>
        <div class="col-xl-5">
            <div class="ol-card p-4">
                <div class="ol-card-body">
                    <form action="<?php echo e(route('client.manage.profile.update')); ?>" method="post"> <?php echo csrf_field(); ?>
                        <div class="fpb7 mb-2">
                            <label class="form-label ol-form-label"><?php echo e(get_phrase('Current password')); ?></label>
                            <input type="password" class="form-control ol-form-control" name="current_password" required />
                        </div>
                        <div class="fpb7 mb-2">
                            <label class="form-label ol-form-label"><?php echo e(get_phrase('New password')); ?></label>
                            <input type="password" class="form-control ol-form-control" name="new_password" required />
                        </div>
                        <div class="fpb7 mb-2">
                            <label class="form-label ol-form-label"><?php echo e(get_phrase('Confirm password')); ?></label>
                            <input type="password" class="form-control ol-form-control" name="confirm_password" required />
                        </div>
                        <div class="fpb7 mb-2">
                            <button type="submit" class="ol-btn-primary"><?php echo e(get_phrase('Update password')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.client', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\academyLMS_sass\Academy-LMS\resources\views/client/profile/index.blade.php ENDPATH**/ ?>